import { auth, db } from './firebase-config.js';
import { createUserWithEmailAndPassword } from "firebase/auth";
import { doc, setDoc } from "firebase/firestore";

export async function register(email, password, username) {
    const userCredential = await createUserWithEmailAndPassword(auth, email, password);
    // Adicionar informações adicionais do usuário no Firestore
    await setDoc(doc(db, "users", userCredential.user.uid), {
        username: username,
        email: email
    });
    return userCredential;
}
